# !/usr/bin/env python
# coding=utf-8

import time
import sys,os
import threading
import serial
import math
import struct, array, time, json
from socket import *

HOST_IP = "192.168.0.201"
HOST_PORT = 333

class datalink :
	def __init__(self):
		self.com = serial.Serial('/dev/ttyS0', 460800, timeout=1.0)
		self.socket_tcp=socket(AF_INET,SOCK_STREAM)
		self.host_addr = (HOST_IP, HOST_PORT)
		self.client=None
		self.client_address=None
		self.data=array.array('B')

	def drone(self):
		while True:
			try:
				if self.com.is_open:
					count=self.com.inWaiting()
					if count>0:
						try:
							c=self.com.read(count)
							n=self.client.send(c)
						except Exception as e:
							print("Error serial:", e)
				else:
					print("串行端口未打开")
			except:
				pass
				continue
	def device(self):
		while True:
			try:
				b=self.client.recv(102400)
				if b!=None:
					if isinstance(b, str):
						self.data.fromstring(b)
					else:
						self.data.extend(b)
					#print(self.data)
					ret=self.com.write(self.data)
					#print(ret)
					self.data=array.array('B')
			except Exception as e:
				print("Waiting for connection...")

def main():
	print('data link is starting...\n')
	dl=datalink()
	drone_thread=threading.Thread(target=dl.drone)
	device_thread=threading.Thread(target=dl.device)
	try:
		dl.socket_tcp.bind(dl.host_addr)
		dl.socket_tcp.listen(5)
		drone_thread.start()
		device_thread.start()
		print("wifi connecting")
		while True:
			dl.client, dl.client_address= dl.socket_tcp.accept()
			dl.client.setsockopt(SOL_TCP, TCP_NODELAY, 1)
			print('client {} connected'.format(dl.client_address))
	except Exception as e:
		print("Error thread:", e)
	finally:
		drone_thread.join()
		device_thread.join()
		dl.com.close()
		dl.socket_tcp.close()

if __name__ == '__main__':
	main()
